/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer.builtin;

import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_10017;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_10201;
import net.minecraft.class_10394;
import net.minecraft.class_11659;
import net.minecraft.class_11786;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5617;
import net.minecraft.class_563;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_836;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibClientServices;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.cache.model.cuboid.CuboidGeoBone;
import software.bernie.geckolib.cache.model.cuboid.GeoCube;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.base.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.service.GeckoLibClient;
import software.bernie.geckolib.util.RenderStateUtil;
import software.bernie.geckolib.util.RenderUtil;

public abstract class ItemArmorGeoLayer<T extends class_1309, O, R extends class_10017>
extends GeoRenderLayer<T, O, R> {
    protected final class_10197 equipmentRenderer;
    protected final class_10201 equipmentAssets;
    protected final Function<// Could not load outer class - annotation placement on inner may be incorrect
    class_2484.class_2485, @Nullable class_5598> skullModels;
    protected final class_11786 skinCache;

    public ItemArmorGeoLayer(GeoRenderer<T, O, R> geoRenderer, class_5617.class_5618 context) {
        super(geoRenderer);
        this.equipmentRenderer = context.method_64072();
        this.equipmentAssets = context.method_64071();
        this.skullModels = class_156.method_34866(type -> class_836.method_32160((class_5599)context.method_32170(), (class_2484.class_2485)type));
        this.skinCache = context.method_73540();
    }

    protected abstract List<RenderData> getRelevantBones(RenderPassInfo<R> var1);

    @Override
    public void addRenderData(T animatable, @Nullable O relatedObject, R renderState, float partialTick) {
        EnumMap equipment = (EnumMap)renderState.getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(class_1304.class));
        this.collectArmorData(renderState, animatable, partialTick, equipment);
        if (!((class_1799)equipment.get(class_1304.field_6174)).method_7960()) {
            renderState.addGeckolibData(DataTickets.ELYTRA_ROTATION, (Object)new class_243((double)((class_1309)animatable).field_52447.method_61404(partialTick), (double)((class_1309)animatable).field_52447.method_61405(partialTick), (double)((class_1309)animatable).field_52447.method_61406(partialTick)));
        }
    }

    protected <S extends class_10034, A extends class_572<S>> void collectArmorData(R baseRenderState, T animatable, float partialTick, EnumMap<class_1304, class_1799> equipment) {
        Object headRenderState = this.getOrCreateHumanoidRenderState(baseRenderState, false);
        ((class_10034)headRenderState).field_55309 = animatable.method_6118(class_1304.field_6169);
        equipment.put(class_1304.field_6169, ((class_10034)headRenderState).field_55309);
        ((class_10034)headRenderState).field_53418 = animatable.method_6118(class_1304.field_6174);
        equipment.put(class_1304.field_6174, ((class_10034)headRenderState).field_53418);
        ((class_10034)headRenderState).field_53419 = animatable.method_6118(class_1304.field_6172);
        equipment.put(class_1304.field_6172, ((class_10034)headRenderState).field_53419);
        ((class_10034)headRenderState).field_53420 = animatable.method_6118(class_1304.field_6166);
        equipment.put(class_1304.field_6166, ((class_10034)headRenderState).field_53420);
        GeoArmorRenderer.captureRenderStates(headRenderState, animatable, partialTick, (renderState, slot) -> (class_572)GeckoLibClient.HUMANOID_ARMOR_MODEL.get().method_72959(slot), slot -> slot == class_1304.field_6169 ? headRenderState : this.getOrCreateHumanoidRenderState(baseRenderState, true));
        baseRenderState.addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, equipment);
        if (headRenderState != baseRenderState && headRenderState.hasGeckolibData(DataTickets.PER_SLOT_RENDER_DATA)) {
            baseRenderState.addGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, (Object)((EnumMap)headRenderState.getGeckolibData(DataTickets.PER_SLOT_RENDER_DATA)));
        }
    }

    @Override
    public void addPerBoneRender(RenderPassInfo<R> renderPassInfo, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        for (RenderData renderData : this.getRelevantBones(renderPassInfo)) {
            renderPassInfo.model().getBone(renderData.boneName).filter(CuboidGeoBone.class::isInstance).ifPresentOrElse(bone -> this.createPerBoneRender(renderPassInfo, (GeoBone)bone, renderData, consumer), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(RenderPassInfo<R> renderPassInfo, GeoBone bone, RenderData renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        GeoArmorRenderer.ArmorSegment armorSegment = renderData.armorSegment;
        class_1799 stack = this.getEquipmentStack(renderPassInfo, bone, armorSegment.equipmentSlot);
        if (!stack.method_7960()) {
            consumer.accept(bone, (renderPassInfo2, bone2, renderTasks) -> this.buildRenderTask(renderPassInfo2, armorSegment.equipmentSlot, armorSegment.modelPartGetter, stack, (CuboidGeoBone)bone2, renderTasks));
        }
    }

    protected void buildRenderTask(RenderPassInfo<R> renderPassInfo, class_1304 slot, Function<class_572<?>, class_630> modelPartFactory, class_1799 equipmentStack, CuboidGeoBone bone, class_11659 renderTasks) {
    }

    protected class_1799 getEquipmentStack(RenderPassInfo<R> renderPassInfo, GeoBone bone, class_1304 slot) {
        return renderPassInfo.getGeckolibData(DataTickets.EQUIPMENT_BY_SLOT).getOrDefault(slot, class_1799.field_8037);
    }

    protected class_10186.class_10190 getEquipmentLayerType(RenderPassInfo<R> renderPassInfo, GeoBone bone, class_1304 slot, class_1799 armorStack, class_5321<class_10394> assetId) {
        if (slot == class_1304.field_6172) {
            return class_10186.class_10190.field_54126;
        }
        if (slot == class_1304.field_6174 && !this.equipmentAssets.method_64087(assetId).method_63996(class_10186.class_10190.field_54127).isEmpty()) {
            return class_10186.class_10190.field_54127;
        }
        return class_10186.class_10190.field_54125;
    }

    protected void renderVanillaArmorPiece(RenderPassInfo<R> renderPassInfo, class_4587 poseStack, GeoBone bone, class_1304 slot, class_1799 armorStack, class_10192 equippable, class_5321<class_10394> assetId, class_3879<?> model, class_630 modelPart, class_11659 renderTasks) {
        class_10186.class_10190 layerType = this.getEquipmentLayerType(renderPassInfo, bone, slot, armorStack, assetId);
        class_3879 modelToRender = model;
        if (layerType == class_10186.class_10190.field_54127) {
            if (model instanceof class_572) {
                class_572 humanoidModel = (class_572)model;
                if (modelPart != humanoidModel.field_3391) {
                    return;
                }
            }
            modelToRender = this.checkForElytraModel(renderPassInfo, layerType, bone, poseStack);
        }
        this.equipmentRenderer.method_64077(layerType, assetId, modelToRender, (Object)((class_10017)renderPassInfo.renderState()), armorStack, poseStack, renderTasks, renderPassInfo.packedLight(), ((class_10017)renderPassInfo.renderState()).field_61821);
    }

    protected class_3879 checkForElytraModel(RenderPassInfo<R> renderPassInfo, class_10186.class_10190 layerType, GeoBone bone, class_4587 poseStack) {
        class_563 model = GeckoLibClient.GENERIC_ELYTRA_MODEL.get();
        class_10034 humanoidRenderState = new class_10034();
        class_10017 renderState = (class_10017)renderPassInfo.renderState();
        class_243 elytraRotation = (class_243)renderState.getOrDefaultGeckolibData(DataTickets.ELYTRA_ROTATION, (Object)class_243.field_1353);
        humanoidRenderState.field_53410 = (Boolean)renderState.getOrDefaultGeckolibData(DataTickets.IS_CROUCHING, (Object)false);
        humanoidRenderState.field_53415 = (float)elytraRotation.field_1352;
        humanoidRenderState.field_53416 = (float)elytraRotation.field_1351;
        humanoidRenderState.field_53417 = (float)elytraRotation.field_1350;
        model.method_17079(humanoidRenderState);
        poseStack.method_46416(0.0f, -1.5f, 0.125f);
        return model;
    }

    @ApiStatus.Internal
    protected <S extends class_10034> class_3879<?> getArmorModelForRender(GeoBone bone, class_1304 slot, class_1799 stack, R renderState) {
        class_10034 humanoidRenderState1;
        class_10034 humanoidRenderState = renderState instanceof class_10034 ? (humanoidRenderState1 = (class_10034)renderState) : new class_10034();
        class_10186.class_10190 layerType = slot == class_1304.field_6172 ? class_10186.class_10190.field_54126 : class_10186.class_10190.field_54125;
        class_572 defaultModel = (class_572)GeckoLibClient.HUMANOID_ARMOR_MODEL.get().method_72959(slot);
        return GeckoLibClientServices.ITEM_RENDERING.getArmorModelForItem(humanoidRenderState, stack, slot, layerType, defaultModel);
    }

    protected void renderSkullAsArmor(RenderPassInfo<R> renderPassInfo, GeoBone bone, class_1799 stack, class_2190 skullBlock, class_11659 renderTasks) {
        class_2484.class_2485 type = skullBlock.method_9327();
        class_5598 model = this.skullModels.apply(type);
        if (model == null) {
            return;
        }
        class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
        class_1921 renderType = profile == null ? class_11786.field_62215 : this.skinCache.method_73495(profile).method_73504();
        class_4587 poseStack = renderPassInfo.poseStack();
        poseStack.method_22903();
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.method_22905(1.1875f, 1.1875f, 1.1875f);
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        class_836.method_72958(null, (float)0.0f, (float)0.0f, (class_4587)poseStack, (class_11659)renderTasks, (int)renderPassInfo.packedLight(), (class_5598)model, (class_1921)renderType, (int)((class_10017)renderPassInfo.renderState()).field_61821, null);
        poseStack.method_22909();
    }

    protected RenderPassInfo.BoneUpdater<R> positionModelPartFromBone(class_4587 poseStack, CuboidGeoBone bone, class_630 sourcePart) {
        GeoCube firstCube = bone.cubes[0];
        class_630.class_628 armorCube = (class_630.class_628)sourcePart.field_3663.getFirst();
        double armorBoneSizeX = firstCube.size().method_10216();
        double armorBoneSizeY = firstCube.size().method_10214();
        double armorBoneSizeZ = firstCube.size().method_10215();
        double actualArmorSizeX = Math.abs(armorCube.field_3648 - armorCube.field_3645);
        double actualArmorSizeY = Math.abs(armorCube.field_3647 - armorCube.field_3644);
        double actualArmorSizeZ = Math.abs(armorCube.field_3646 - armorCube.field_3643);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        RenderPassInfo.BoneUpdater modelPositioner = (renderPassInfo, snapshots) -> {
            BoneSnapshot snapshot = snapshots.get(bone);
            sourcePart.method_2851(-(bone.pivotX() - (bone.pivotX() * scaleX - bone.pivotX()) / scaleX), -(bone.pivotY() - (bone.pivotY() * scaleY - bone.pivotY()) / scaleY), bone.pivotZ() - (bone.pivotZ() * scaleZ - bone.pivotZ()) / scaleZ);
            sourcePart.field_3654 = -snapshot.getRotX();
            sourcePart.field_3675 = -snapshot.getRotY();
            sourcePart.field_3674 = snapshot.getRotZ();
        };
        poseStack.method_22905(scaleX, scaleY, scaleZ);
        return modelPositioner;
    }

    protected <S extends class_10034> S getOrCreateHumanoidRenderState(R renderState, boolean forceNew) {
        class_10034 state;
        class_10034 newState;
        class_10034 class_100342 = newState = !forceNew && renderState instanceof class_10034 ? (state = (class_10034)renderState) : new class_10034();
        if (newState != renderState) {
            RenderStateUtil.makeMinimalArmorRenderingClone(newState, renderState);
        }
        return (S)newState;
    }

    private /* synthetic */ void lambda$buildRenderTask$6(class_4587 poseStack, CuboidGeoBone bone, class_630 modelPart, RenderPassInfo renderPassInfo, class_1304 slot, class_1799 equipmentStack, class_10192 equippable, class_3879 vanillaModel, class_11659 renderTasks, class_5321 assetId) {
        this.positionModelPartFromBone(poseStack, bone, modelPart);
        this.renderVanillaArmorPiece(renderPassInfo, poseStack, bone, slot, equipmentStack, equippable, (class_5321<class_10394>)assetId, vanillaModel, modelPart, renderTasks);
    }

    public record RenderData(String boneName, GeoArmorRenderer.ArmorSegment armorSegment) {
        public static RenderData head(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.HEAD);
        }

        public static RenderData body(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.CHEST);
        }

        public static RenderData leftArm(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_ARM);
        }

        public static RenderData rightArm(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_ARM);
        }

        public static RenderData leftLeg(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_LEG);
        }

        public static RenderData rightLeg(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_LEG);
        }

        public static RenderData leftFoot(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_FOOT);
        }

        public static RenderData rightFoot(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_FOOT);
        }
    }
}

